﻿using System;
using System.Collections.Generic;
using System.Text;

namespace System.Data.SQLite.Vfs.Async.Test
{
    class TestProgram
    {
        static void DbTestMethod()
        {
            string connectionString = "data source = c:\\testDatabase.db;synchronous = Full;failifmissing = False;pooling = False;journal mode = Persist;locking mode = EXCLUSIVE;temp store = MEMORY";

            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 10000; ++i)
                sb.Append('a');
            string bigString = sb.ToString();

            using (System.Data.SQLite.SQLiteConnection connection = new System.Data.SQLite.SQLiteConnection(connectionString))
            using (System.Data.SQLite.SQLiteCommand create = new System.Data.SQLite.SQLiteCommand("CREATE TABLE IF NOT EXISTS test ( data STRING )", connection))
            using (System.Data.SQLite.SQLiteCommand insert = new System.Data.SQLite.SQLiteCommand("INSERT INTO test ( data ) VALUES ( @data )", connection))
            using (System.Data.SQLite.SQLiteCommand count = new System.Data.SQLite.SQLiteCommand("SELECT COUNT(data) FROM test", connection))
            {
                insert.Parameters.Add(new SQLiteParameter("@data", System.Data.DbType.String));

                connection.Open();
                create.ExecuteNonQuery();

                Console.WriteLine("start = " + DateTime.Now);

                // FOR TEST PURPOSES ONLY, does inserts in multiple transactions is no faster with the
                // async writer. Just the writing to disk is delayed until later
                // Real code should have: using(SQLiteTransaction transaction = connection.BeginTransaction()) {
                for (int i = 0; i < 100; ++i)
                {
                    insert.Parameters[0].Value = i + bigString;
                    insert.ExecuteNonQuery();
                }
                // Real code should have: transaction.Commit() }

                Console.WriteLine("post insert = " + DateTime.Now);
                Console.WriteLine("db rows = " + (Int64)count.ExecuteScalar());    // prove reads get data before flush
                SQLiteAsync.Flush();
                Console.WriteLine("post flush = " + DateTime.Now);
                Console.WriteLine("db rows (expect same as before flush) = " + (Int64)count.ExecuteScalar());

                for (int i = 100; i < 200; ++i)
                {
                    insert.Parameters[0].Value = i + bigString;
                    insert.ExecuteNonQuery();
                }

                Console.WriteLine("post insert2 = " + DateTime.Now);
                Console.WriteLine("db rows = " + (Int64)count.ExecuteScalar());
            }
        }

        static void Main(string[] args)
        {
            Console.WriteLine("==== Without async vfs ==== (expect flush time of 0)");
            DbTestMethod();

            Console.WriteLine("==== With async vfs ==== (expect insert time of ~0, flush/shutdown time of ~'without async' insert time)");
            SQLiteAsync.Initialize(true);

            DbTestMethod();

            SQLiteAsync.Shutdown();
            Console.WriteLine("post shutdown = " + DateTime.Now);

            Console.WriteLine("==== Without async vfs ====");
            DbTestMethod();
        }
    }

}
